/*
 * Decompiled with CFR 0.152.
 */
package PSG_Emu;

public class SoundTable {
    private int nbr_table;
    private byte[][] table = new byte[4][];
    private int[] position = new int[4];
    private int table_no;

    public SoundTable() {
        this.setNumber(1);
    }

    public SoundTable(int n) {
        this.setNumber(n);
    }

    public void setNumber(int n) {
        this.nbr_table = n;
        for (int i = 0; i < n; ++i) {
            this.table[i] = new byte[10];
            this.position[i] = 0;
        }
        this.table_no = 0;
    }

    public void add(byte by) {
        if (this.position[this.table_no] + 1 == this.table[this.table_no].length) {
            byte[] byArray = new byte[this.table[this.table_no].length + 1];
            System.arraycopy(this.table[this.table_no], 0, byArray, 0, this.table[this.table_no].length);
            this.table[this.table_no] = byArray;
        }
        int n = this.table_no;
        int n2 = this.position[n];
        this.position[n] = n2 + 1;
        this.table[this.table_no][n2] = by;
    }

    public void add(String string) {
        if (this.position[this.table_no] + 1 == this.table[this.table_no].length) {
            byte[] byArray = new byte[this.table[this.table_no].length + 10];
            System.arraycopy(this.table[this.table_no], 0, byArray, 0, this.table[this.table_no].length);
            this.table[this.table_no] = byArray;
        }
        int n = this.table_no;
        int n2 = this.position[n];
        this.position[n] = n2 + 1;
        this.table[this.table_no][n2] = this.decode(string);
    }

    private byte decode(String string) {
        int n = 0;
        if (string.matches("0x.*")) {
            int n2 = string.indexOf("0x");
            n = Integer.parseInt(string.substring(n2 += 2, string.length() + 1).toLowerCase().trim(), 16);
        } else if (string.matches(".*h")) {
            int n3 = string.indexOf("h");
            n = Integer.parseInt(string.substring(0, n3).toLowerCase().trim(), 16);
        } else {
            n = Integer.parseInt(string.trim(), 10);
        }
        byte by = (byte)(n & 0xFF);
        return by;
    }

    public void next_table() {
        ++this.table_no;
        if (this.table_no == this.nbr_table) {
            this.table_no = 0;
        }
    }

    public byte[] get_table(int n) {
        if (n >= this.nbr_table) {
            n = 0;
        }
        return this.table[n];
    }

    public int get_table_length(int n) {
        if (n >= this.nbr_table) {
            n = 0;
        }
        return this.position[n];
    }

    public int numberOfTable() {
        return this.nbr_table;
    }

    public int sampleMethod(int n) {
        return n + n;
    }
}

